## -*-Tcl-*-
 # ###################################################################
 #  HTML and CSS mode - tools for editing Cascading Style Sheets
 # 
 #  FILE: "hctsmslMenu.tcl"
 #                                    created: 97-03-01 17.33.59 
 #                                last update: 99-04-24 13.19.58 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 2.1.4 and 1.1.1
 # 
 # Copyright 1996-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

proc hctsmslMenu.tcl {} {}

# Variables defining submenus.
set htmlStyleSub {{"" Style STYLE} {"<B/b" Span SPAN} "(-" {"" "Import"} {"" Font} {"" Color}
	{"" Background} {"" Text} {"" Margin}
	{"" Padding} {"" Border} {"" "Border Width"} {"" "Border Style"}
	{"" "Border Color"} {"" Size} {"" Float} 
	{"" Clear} {"" Display} {"" "List Style"}}

set htmlHeadersSub {{"<B<O/1" "Header1/H1 no attr" H1}
	{"<B<O/2" "Header2/H2 no attr" H2}
	{"<B<O/3" "Header3/H3 no attr" H3}
	{"<B<O/4" "Header4/H4 no attr" H4}
	{"<B<O/5" "Header5/H5 no attr" H5}
	{"<B<O/6" "Header6/H6 no attr" H6}}

set htmlBlocksSub {{"" "Insert Line Breaks/Remove Line Breaks"}
	{"" "Insert Paragraphs"} "(-"
	{"<U/b" "Paragraph/P no attr" P}
	{"<U<O/b" "Division" DIV}
	{"<B<O/Q" "Block Quote" BLOCKQUOTE} {"<B<O/S" "Address" ADDRESS}
	{"<B<O/C" "Center" CENTER} {"<B<O/P" "Preformatted" PRE}
	{"<B<O/X" "Multi Column" MULTICOL}
	{"<B<O/Z" "Spacing" SPACER} {"" "Direction Override" BDO} {"<B<O/u" "Inserted Text" INS}
	{"<B<O/v" "Deleted Text" DEL} "(-"
	{"<O/b" "Line Break/BR no attr" BR}
	{"<B<O/H" "Horizontal Rule/HR no attr" HR}
	{"<B<O/B" "No Line Break" NOBR} {"<B<O/W" "Word Break" WBR}}

set htmlStylesSub {{"<B<I/F" Font FONT} {"<B<I/N" Basefont BASEFONT}
	{"<B<I/M" Marquee MARQUEE} "(-" {"<B<I/B" Bold B}
	{"<B<I/I" Italic I} {"<B<I/-" "Strike out" STRIKE} {"<B<I<O/-" Underlined U}
	{"<B<I/." Superscript SUP} {"<B<I/," Subscript SUB} {"<B<I<O/." Bigger BIG}
	{"<B<I<O/," Smaller SMALL} {"<B<I/T" Typewriter TT} {"<B<I/Z" Blinking BLINK}
	"(-" {"<B<I/Q" Quotation Q} {"<B<I/A" Abbreviation ABBR} {"<B<I/Y" Acronym ACRONYM} 
	{"<B<I/E" Emphasis EM} {"<B<I/S" Strong STRONG} {"<B<I/D" Definition DFN}
	{"<B<I/C" Code CODE} {"<B<I/V" Variable VAR}	{"<B<I/X" Citation CITE} 
	{"<B<I/K" Keyboard KBD} {"<B<I/P" Sample SAMP}}

set htmlLinksSub {{"<B<O/A" "Link or Anchor" A} {"<B<O/I" Image IMG}
	{"<B<O/T" Object OBJECT} {"" Sound BGSOUND}}

set htmlPlug-insSub {{"<B<O/E" General EMBED} {"" LiveAudio EMBED}
	{"" LiveVideo EMBED} {"" "QuickTime Movie" EMBED}
	{"" "QuickTime VR" EMBED} {"" RealAudio EMBED} "(-" {"<B<O/N" "No Embed" NOEMBED}}

set htmlListsSub {{"" "Make List"} "(-" {"<B<O/U" "Bulleted/UL no attr" UL}
	{"<B<I/U" "New Bulleted Item"}
	{"<B<O/O" "Numbered/OL no attr" OL}
	{"<B<I/O" "New Numbered Item"} {"<B<O/D" "Directory" DIR}
	{"<B<O/M" "Menu" MENU} {"<B<I/L" "New List Item" LI} "(-"
	{"<B<U<O/D" "Discursive" DL} {"<B<I<O/L" "New Discursive Entry"}}

set htmlFormsSub {{"<B<U/F" Form FORM} {"<B<U/D" "Field Set" FIELDSET} {"<B<U/L" Legend LEGEND}
	{"<B<U/E" Label LABEL} "(-" {"<B<U/T" Text INPUT}
	{"<B<U/B" Checkbox  INPUT} {"<B<U/N" "Input Button" INPUT}
	{"<B<U/R" Radio INPUT} {"<B<U/S" Submit INPUT}
	{"<B<U/C" Reset INPUT} {"<B<U/P" Password INPUT}
	{"<B<U/H" Hidden INPUT} {"<B<U/I" Image INPUT}
	{"<B<U/U" "File Upload" INPUT}
	"(-" {"<B<U<I/U" Button BUTTON} {"<B<U<I/S" Select SELECT} {"<B<U/G" "Option Group" OPTGROUP}
	{"<B<U/O" Option OPTION} {"<B<U<I/T" Textarea TEXTAREA} {"" "Key Generator" KEYGEN}}

set htmlTablesSub {{"" "Table Template"} {"" "Tabs to Rows/Rows to Tabs"} {"" "Import Table"} "(-"
	{"<U<O/T" Table TABLE} {"<U<O/R" "Row/TR no attr" TR}
	{"<U<O/H" "Header/TH no attr" TH} {"<U<O/D" "Cell/TD no attr" TD}
	{"<U<O/C" Caption CAPTION} "(-"
	{"<B<U<O/H" Head THEAD} {"<B<U<O/B" Body TBODY} {"<B<U<O/F" Foot TFOOT}
	"(-" {"<B<U<O/G" "Column Group" COLGROUP} {"<B<U<O/C" "Column" COL}}

set htmlFramesSub {{"<B<U<I/F" "New Doc. with Frames"} "(-" {"<B<U<I/O" Frameset FRAMESET}
	{"<B<U<I/R" Frame FRAME} {"" "Inline Frame" IFRAME}
	{"<B<U<I/N" "No Frames" NOFRAMES}}

set htmlImageSub {{"" "Convert NCSA Map"} {"" "Convert CERN Map"} "(-" {"<B<U/M" Map MAP} 
	{"<B<U/A" Area AREA}}

set htmlJavaSub {{"<U<I<O/J" Applet APPLET} {"<U<I<O/P" Parameter PARAM}
	"(-" {"<U<I<O/S" Script SCRIPT} {"<U<I<O/N" "No Script" NOSCRIPT} {"" Server SERVER}}

set htmlLayersSub {{"" Layer LAYER} {"" "Inline Layer" ILAYER} {"" "No Layer" NOLAYER}}

set htmlOtherSub {{"<B<U<I/C" Comment} {"<B<U<I/B" Base BASE}
	{"<B<U<I/I" Isindex ISINDEX}
	{"<B<U<I/L" Link LINK} {"<B<U<I/M" Meta META} {"" "Comment Line"}}

set htmlSubMenus {HTML Browsers Preferences
{Style Sheets} Headers {Blocks and Dividers} Styles Links 
Plug-ins Lists Forms Tables Frames {Image Maps} {Java and JavaScript} Layers Other}

# Index of which menu is the first with HTML elements.
set htmlStartElements 3

# Returns a list defining a submenu.
proc htmlBuildOneMenu {me} {
	global htmlMenuKey
	set me0 [lindex $me 0]
	global html${me0}Sub
	# CSS menu share with Style menu
	if {$me0 == "CSS"} {set me0 Style}
	set tmp ""
	foreach it [set html[lindex $me 0]Sub] {
		if {$it == "(-"} {lappend tmp $it; continue}
		if {[info exists htmlMenuKey(${me0}/[lindex $it 1])]} {
			set key $htmlMenuKey(${me0}/[lindex $it 1])
		} else {
			set key [lindex $it 0]
		}
		set it2 [split [lindex $it 1] /]
		if {[llength $it2] == 1} {
			lappend tmp "$key[lindex $it2 0]"
		} elseif {$key != ""} {
			lappend tmp "<S$key[lindex $it2 0]" "<S<I$key[lindex $it2 1]"
		} else {
			lappend tmp "<S$key[lindex $it2 1]" "<S$key[lindex $it2 0]"
		}
	}
	return $tmp
}

# Rebuilds a submenu.
proc htmlRebuildOneMenu {me {deleteCache 0}} {
	set meny [htmlBuildOneMenu [lindex $me 0]]
	menu -M HTML -p htmlMenuItem -m -n $me $meny
	if {[info commands "html[lindex $me 0]MenuExtra"] != ""} {
		eval html[lindex $me 0]MenuExtra
	}
	if {$deleteCache} {
		htmlDeleteCache "HTML menu cache"
		htmlDeleteCache "HTML Utilities menu cache"
	}
	htmlDisMark
	htmlUtilDisMark
}

#===============================================================================
# Custom Key Bindings
#===============================================================================

proc htmlReadMenuKeys {} {
	global PREFS
	if {[file exists "$PREFS:HTML:Menu key bindings"]} {
		catch {uplevel #0 [list source "$PREFS:HTML:Menu key bindings"]}
	}
}

proc htmlWriteMenuKeys {} {
	global PREFS htmlMenuKey
	if {![info exists htmlMenuKey]} {return}
	message "Saving custom key bindings"
	foreach m [array names htmlMenuKey] {
		lappend txt "set htmlMenuKey(\[list $m\]) [list $htmlMenuKey($m)]"
	}
	if {![file exists $PREFS]} {mkdir $PREFS}
	if {![file exists $PREFS:HTML]} {mkdir $PREFS:HTML}
	set fid [open "$PREFS:HTML:Menu key bindings" w]
	puts $fid [join $txt \n]
	close $fid
	unset htmlMenuKey
}

proc htmlKeyBindings {} {
	global htmlSubMenus htmlUtilSubMenus htmlMenuKey
	set ret ""
	set rebuildHTML 0
	set rebuildUtils 0
	set rebuildCSS 0
	set somethingModified 0
	htmlReadMenuKeys
	if {![catch {listpick -p "Choose a submenu to change key bindings in" \
	  [lsort [concat $htmlSubMenus $htmlUtilSubMenus {{Small Chars} {Capital Chars} {Other Chars 1} {Other Chars 2}}]]} meny] && $meny != ""} {
		if {[string match "*Chars*" $meny]} {
			catch {htmlSetEntityKeys $meny}
		} else {
			catch {htmlSetKeysInMenu $meny}
		}
	}
	if {$somethingModified} {htmlWriteMenuKeys}
	if {$rebuildHTML} {htmlRebuildMenu "Rebuilding HTML menu"; message "Done."}
	if {$rebuildUtils} {htmlRebuildUtilsMenu "Rebuilding HTML Utilities menu"; message "Done."}
	if {$rebuildCSS} {cssRebuildMenu}
	catch {unset htmlMenuKey}
}


# Redefine key bindings in one submenu.
proc htmlSetKeysInMenu {meny} {
	global htmlMenuKey htmlModeIsLoaded cssModeIsLoaded
	
	set meny0 [lindex $meny 0]
	global html${meny0}Sub
	# CSS menu share with Style menu
	if {$meny0 == "CSS"} {set meny0 Style}
	set items [set html[lindex $meny 0]Sub]
	regsub -all {\"\(-\"} $items "" items
	foreach it $items {
		if {[info exists htmlMenuKey(${meny0}/[lindex $it 1])]} {
			set tmpKeys([lindex $it 1]) $htmlMenuKey(${meny0}/[lindex $it 1])
		} else {
			set tmpKeys([lindex $it 1]) [lindex $it 0]
		}
		lappend items2 [list $tmpKeys([lindex $it 1]) [lindex $it 1]]
	}
	if {[eval dialog::adjustBindings [list $meny] newKeys modified 1 $items2] == "Cancel"} {return}

	# Save new key bindings
	foreach it $modified {
		set htmlMenuKey(${meny0}/$it) $newKeys($it)
	}
	if {[llength $modified]} {
		htmlDeleteCache "CSS keybindings cache"
		uplevel 1 {set somethingModified 1}
		switch $meny {
			HTML {uplevel 1 {set rebuildHTML 1}}
			Utilities {uplevel 1 {set rebuildUtils 1}}
			"Style Sheets" {
				# Rebuild both Style sheet menu and CSS menu
				htmlDeleteCache "CSS menu cache"
				htmlRebuildOneMenu "Style Sheets" 1
				if {[info exists cssModeIsLoaded]} {uplevel 1 {set rebuildCSS 1}}
			}
			CSS {
				# Rebuild both Style sheet menu and CSS menu
				if {[info exists htmlModeIsLoaded]} {
					htmlRebuildOneMenu "Style Sheets" 1
				} else {
					htmlDeleteCache "HTML menu cache"
				}
				uplevel 1 {set rebuildCSS 1}
			}
			default {
				htmlRebuildOneMenu $meny 1
				# Redefine key bindinds in CSS mode.
				if {[info exists cssModeIsLoaded]} {
					foreach k [array names newKeys] {
						lappend re [list $k $tmpKeys($k) $newKeys($k)]
						cssReBindKey $meny0 $re
					}
				}
			}
		}
	}
}

